﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Utilities;
using System.Data;

namespace AZVIC.Ei8htPOS.Entities
{
    public class ProductsXMeasurements
    {

        public ProductsXMeasurements()
        {

        }

        public ProductsXMeasurements(IDataReader myDataRecord)
        {
            ProductsXMeasurementID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ProductsXMeasurementID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("ProductsXMeasurementID"));
            BaseSizeID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("BaseSizeID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("BaseSizeID"));
            TargetSizeID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("TargetSizeID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("TargetSizeID"));
            ProductID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ProductID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("ProductID"));
            TargetSizeName = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("TargetSizeName")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("TargetSizeName"));
            TargetConversion = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("TargetConversion")) ? 0 : myDataRecord.GetInt32(myDataRecord.GetOrdinal("TargetConversion"));
            CreatedDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CreatedDate")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("CreatedDate"));
            ModifiedDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ModifiedDate")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("ModifiedDate"));
            CreatedBy = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CreatedBy")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("CreatedBy"));
            ModifiedBy = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ModifiedBy")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("ModifiedBy"));
            IsActive = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsActive")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsActive"));
            
        }

        [DataObjectField(true, false, false)]
        public Guid ProductsXMeasurementID { get; set; }

        public Guid BaseSizeID { get; set; }

        public Guid TargetSizeID { get; set; }

        public Guid ProductID { get; set; }

        public int TargetConversion { get; set; }

        public DateTime ModifiedDate { get; set; }

        public DateTime CreatedDate { get; set; }

        public Guid CreatedBy { get; set; }

        public Guid ModifiedBy { get; set; }

        public bool IsActive { get; set; }

        public string TargetSizeName { get; set; }

    }
}
